﻿namespace Microsoft.Samples.PlanMyNight.Web.Infrastructure
{
    using System.ComponentModel.Composition.Hosting;
    using System.ComponentModel.Composition.Primitives;
    using System.IO;
    using System.Linq;

    public class AddinsDirectoryCatalog : ComposablePartCatalog
    {
        private AggregateCatalog internalCatalog;

        private FileSystemWatcher watcher;

        private string addinsPath;

        public AddinsDirectoryCatalog(string addinsPath)
        {
            this.addinsPath = addinsPath;
            this.internalCatalog = new AggregateCatalog();
            this.Refresh();

            this.watcher = new FileSystemWatcher(this.addinsPath, "*.*")
            {
                IncludeSubdirectories = true,
                EnableRaisingEvents = true
            };

            this.watcher.Changed += this.FileWatcherChanged;
            this.watcher.Deleted += this.FileWatcherChanged;
            this.watcher.Created += this.FileWatcherChanged;
        }

        public override IQueryable<ComposablePartDefinition> Parts
        {
            get { return this.internalCatalog.Parts; }
        }

        public void Refresh()
        {
            lock (this.internalCatalog)
            {
                this.internalCatalog.Catalogs.Clear();
                foreach (var dir in Directory.GetDirectories(this.addinsPath))
                {
                    var path = Path.Combine(dir, "bin");
                    if (Directory.Exists(path))
                    {
                        var catalog = new DirectoryCatalog(path);
                        this.internalCatalog.Catalogs.Add(catalog);
                    }
                }
            }
        }

        private void FileWatcherChanged(object sender, FileSystemEventArgs e)
        {
            this.Refresh();
        }
    }
}